/******************************************************************************/
#include "stdafx.h"
/******************************************************************************

   Because the main methods of Gui Objects are virtual, you can extend them.

/******************************************************************************/
struct Button2 : Button // Create a new class extending the default Gui Button
{
   virtual void     test  (GuiPC &gpc); // extend testing if object is under mouse cursor
   virtual Button2& update(GuiPC &gpc); // extend updating   object
   virtual void     draw  (GuiPC &gpc); // extend drawing    object
};

void Button2::test(GuiPC &gpc) // extend testing
{
   __super::test(gpc); // call default method
}

Button2& Button2::update(GuiPC &gpc) // extend updating
{
   __super::update(gpc); // call default method
   return T;             // return self
}

void Button2::draw(GuiPC &gpc) // extend drawing
{
   __super::draw(gpc); // call default method
}
/******************************************************************************/
Button2 button; // create a sample button
/******************************************************************************/
void InitPre()
{
   App.name="Extending Gui Objects";
   App.flag=APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("../data/engine.pak");
   D.mode(800,600).sync(true);
}
/******************************************************************************/
Bool Init()
{
   Gui+=button.create(Rect_C(0,0,0.5,0.1),"New Button");
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();
   return true;
}
/******************************************************************************/
void Draw()
{
   D  .clear();
   Gui.draw ();
}
/******************************************************************************/
